/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft;

import com.tiviacz.pizzacraft.client.gui.ScreenPizza;
import com.tiviacz.pizzacraft.client.gui.ScreenPizzaBag;
import com.tiviacz.pizzacraft.client.renderer.BasinRenderer;
import com.tiviacz.pizzacraft.client.renderer.ChoppingBoardRenderer;
import com.tiviacz.pizzacraft.client.renderer.MortarAndPestleRenderer;
import com.tiviacz.pizzacraft.client.renderer.PizzaRenderer;
import com.tiviacz.pizzacraft.compat.curios.PizzaBagCurioRenderer;
import com.tiviacz.pizzacraft.config.PizzaCraftConfig;
import com.tiviacz.pizzacraft.init.ModAdvancements;
import com.tiviacz.pizzacraft.init.ModBlockEntityTypes;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModConfiguredFeatures;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.ModLootModifiers;
import com.tiviacz.pizzacraft.init.ModMenuTypes;
import com.tiviacz.pizzacraft.init.ModPlacedFeatures;
import com.tiviacz.pizzacraft.init.ModRecipes;
import com.tiviacz.pizzacraft.init.ModSounds;
import com.tiviacz.pizzacraft.init.ModVanillaCompat;
import com.tiviacz.pizzacraft.init.PizzaLayers;
import com.tiviacz.pizzacraft.recipes.BasinRecipeRegistry;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod(value="pizzacraft")
public class PizzaCraft {
    public static final String MODID = "pizzacraft";
    public static final Logger LOGGER = LogManager.getLogger();
    public static boolean curiosLoaded;

    public PizzaCraft() {
        PizzaCraftConfig.register(ModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onFinish);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onEnqueueIMC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.register(modEventBus);
        ModMenuTypes.MENU_TYPES.register(modEventBus);
        ModRecipes.SERIALIZERS.register(modEventBus);
        ModRecipes.RECIPE_TYPES.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModPlacedFeatures.PLACED_FEATURES.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        ModConfiguredFeatures.CONFIGURED_FEATURES.register(modEventBus);
        curiosLoaded = ModList.get().isLoaded("curios");
    }

    private void onEnqueueIMC(InterModEnqueueEvent event) {
        if (!curiosLoaded) {
            return;
        }
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModAdvancements.register();
            ModVanillaCompat.setup();
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PIZZA.get()), ScreenPizza::new);
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.PIZZA_BAG.get()), ScreenPizzaBag::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.CHOPPING_BOARD.get()), ChoppingBoardRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.MORTAR_AND_PESTLE.get()), MortarAndPestleRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.BASIN.get()), BasinRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.PIZZA.get()), PizzaRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PIZZA.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RAW_PIZZA.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OVEN.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.RED_PIZZA_BAG.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OLIVE_SAPLING.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OLIVE_LEAVES.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.FRUIT_OLIVE_LEAVES.get()), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.OLIVE_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.BROCCOLI.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CORNS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CUCUMBERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.ONIONS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PEPPERS.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.PINEAPPLE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.TOMATOES.get()), (RenderType)RenderType.m_110463_());
        if (curiosLoaded) {
            this.registerCurioRenderer();
        }
    }

    private void registerCurioRenderer() {
        CuriosRendererRegistry.register((Item)((Item)ModItems.RED_PIZZA_BAG.get()), PizzaBagCurioRenderer::new);
    }

    private void onFinish(FMLLoadCompleteEvent event) {
        BasinRecipeRegistry.addRecipesToRegistry();
        PizzaLayers.setMaps();
    }
}

